function [imX,imMAP,sFile]=loadimg(sArgument);
%% -------------------------------------------------------------------- %%
% Function: һͼļ
%           if Ϊ
%              򿪵ǰĿ¼ѡһͼļ;
%           else
%              if '\'β
%                 򿪸òضĿ¼ѡһͼļ;
%              else
%                 򿪸òضļ;
%              end
%           end
%   Author: Shuozhong Wang, Wei Weimin
% Argument: sArgument: 
%           imX: image data
%           imMAP: colormap
%           sFile: ļ
%  Example: iCover = loadimg('d:\images\lena.bmp'); % ضļ
%           iCover = loadimg('d:\temp\'); % ضĿ¼,ע'\'β
%           iCover = loadimg; % ǰĿ¼
%  Version: 2.02.20080625,1.03.20070912
%    Email: weiweimin@hotmail.com
%      Web: http://www.TrueMark.cn
%% -------------------------------------------------------------------- %%

imX = []; imMAP = []; sFile = '';

if ~nargin % ǰĿ¼
    sFilterSpec = '*.bmp;*.gif;*.jpg;*.jpeg;*.tif;*.tiff';
else
    if sArgument(length(sArgument)) == '\' % ضĿ¼
        sFilterSpec = [sArgument,'*.bmp;*.gif;*.jpg;*.jpeg;*.tif;*.tiff'];
    else
        sFile = sArgument; % ضļ
    end
end

if isempty(sFile)
    sDialogTitle = 'Please select an image file';
    [filename, pathname] = uigetfile(sFilterSpec, sDialogTitle);
    if isequal(filename,0) || isequal(pathname,0) % User pressed Cancel
        disp('User pressed Cancel');
        return;
    end
    sFile=[pathname filename];
end

try
    [imX,imMAP]=imread(sFile);
catch
    disp(['Error: Can not open file [',sFile,']']);
    return;
end

[iH iW iL]=size(imX);

disp(['Loaded image [',num2str(iH),'*',num2str(iW),'*',num2str(iL),']: ',sFile]);

%% -------------------------------------------------------------------- %%